﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class PortThreadPriority : UserControl, ICorrespondenceOS, IControl
    {
        private PortThreadPriorityController portThreadPriorityController;

        public PortThreadPriority()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           
#if DEBUG
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       }; 
        }


        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:portthreadpriority"));
                userHelp.Show();
            }
        }

        public void SetPortThreadPriorityValue(int i)
        {
            switch (i)
            {
                case 0xFFFFFF:
                    radioButton1.Checked = true;
                    break;
                case 1:
                    radioButton3.Checked = true;
                    break;
                default:
                    radioButton2.Checked = true;
                    break;
            }
        }


        public int GetPortThreadPriorityValue()
        {
            if (radioButton1.Checked)
            {
                return 0xFFFFFF;
            }
            if (radioButton2.Checked)
            {
                return 0;
            }
            return 1;
        }

        #region IControl メンバ

        public void Apply()
        {
            portThreadPriorityController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return portThreadPriorityController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList
        {
            get;
            set;
        }

        #endregion

        private void PortThreadPriority_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            portThreadPriorityController = new PortThreadPriorityController(this,
                                                                                    (IPortThreadPriorityStrategy)
                                                                                    wfUtillity.GetCorrespondenceInstance
                                                                                        (new List<ICorrespondenceOS>
                                                                                             {
                                                                                                 new PortThreadPriorityDefaultStrategy()
                                                                                             }));
            portThreadPriorityController.Read();
        }
    }
}
